/*
 * Title  : stat_sch_run.sql
 * Author : EXADIME LLC
 * Created: 05-Oct-2025
 * Updated: 05-Oct-2025
 * Release: 1.0.0
 * Purpose: To gather statistics for the given schema.
 * Comment: Only for one schema.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_owner char prompt 'Enter Table Owner: '
accept p_table char prompt 'Enter Table Name: '
accept p_percent char prompt 'Enter Percent [10]: ' default 10
accept p_degree char prompt 'Enter Parallel [4]: ' default 4

spool &&rpt_dir/stat_sch_run.rpt

set echo on
exec dbms_stats.gather_schema_stats((OWNNAME=>upper('&&p_owner'),CASCADE=>TRUE,DEGREE=>&&p_degree,estimate_percent =>&&p_percent,granularity=>'ALL');
set echo off

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
