/*
 * Title  : sho_user_role.sql
 * Author : EXADIME LLC
 * Created: 14-Sep-2025
 * Updated: 14-Sep-2025
 * Release: 1.0.0
 * Purpose: Lists all the roles granted for the given user.
 * Comment: None
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_user char prompt 'Enter User Name: '

col sno            format 999	heading "#"
col granted_role   format a30	heading "Granted Role"

spool &&rpt_dir/sho_user_role.rpt

select 
        rownum sno,
        granted_role
from (
        select
	       granted_role
        from
		dba_role_privs a,
		dba_users b
	where 
		a.grantee=b.username
        and	a.grantee=upper('&&p_user')
);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
