/*
 * Title  : sho_sch_size.sql
 * Author : EXADIME LLC
 * Created: 15-Oct-2020
 * Updated: 15-Oct-2020
 * Release: 1.0.0
 * Purpose: Shows size of the given schema.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 250
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum format 999         heading "#"
col owner  format a20         heading "Name"
col size   format 999,999,999 heading "MB|Size"

compute sum of "Size" on report
break on report

accept p_schema prompt 'Enter Schema Name:'

spool &&rpt_dir/sho_sch_size.rpt

select 
	owner, 
	sum(bytes)/1024/1024 "Size"
from 
	dba_extents
where
	owner=upper('&&p_schema')
group by 
	owner
order by
	1;

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
