/*
 * Title  : sho_obj_cnt.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: This script shows object count.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "Owner" format a30
col "Object Type" format a30
col "Object Count" format 999,999,999,999

compute sum of "Object Count" on report

break on report

accept p_order_col char prompt "Enter order by column {1|2} [asc|desc] " default 1,2

spool &&rpt_dir/sho_obj_cnt.rpt

select 
	owner		"Owner",
	count(1)	"Object Count"
from	
	dba_objects
where	
	owner not in (
		'ANONYMOUS',
		'APEX_040200',
		'APEX_PUBLIC_USER',
		'APPQOSSYS',
		'AUDSYS',
		'BI',
		'CTXSYS',
		'DBSNMP',
		'DIP',
		'DSSYS',
		'DVF',
		'DVSYS',
		'EXFSYS',
		'FLOWS_3000',
		'FLOWS_FILES',
		'GSMADMIN_INTERNAL',
		'GSMCATUSER',
		'GSMUSER',
		'HR',
		'IX',
		'LBACSYS',
		'MDDATA',
		'MDSYS',
		'MGMT_VIEW',
		'ODM',
		'ODM_MTR',
		'OE',
		'OJVMSYS',
		'OLAPSYS',
		'OPS$ORACLE',
		'ORACLE_OCM',
		'ORADATA',
		'ORADBA',
		'ORDPLUGINS',
		'ORDSYS',
		'OUTLN',
		'OWBSYS',
		'PERFSTAT',
		'PM',
		'PUBLIC',
		'REPADMIN',
		'SCOTT',
		'SH',
		'SI_INFORMTN_SCHEMA',
		'SPATIAL_CSW_ADMIN_USR',
		'SPATIAL_WFS_ADMIN_USR',
		'SQLTXADMIN',
		'SQLTXPLAIN',
		'SYS',
		'SYSBACKUP',
		'SYSDG',
		'SYSKM',
		'SYSMAN',
		'SYSTEM',
		'TRACESVR',
		'TSMSYS',
		'WK_TEST',
		'WKPROXY',
		'WKSYS',
		'WMSYS',
		'XDB',
		'XS$NULL',
		'GGS'
	)
and	object_name not like 'BIN$%'
group by
	owner
order by
	&&p_order_col;

select 
	owner		"Owner",
	object_type	"Object Type",
	count(1)	"Object Count"
from	
	dba_objects
where	
	owner not in (
		'ANONYMOUS',
		'APEX_040200',
		'APEX_PUBLIC_USER',
		'APPQOSSYS',
		'AUDSYS',
		'BI',
		'CTXSYS',
		'DBSNMP',
		'DIP',
		'DSSYS',
		'DVF',
		'DVSYS',
		'EXFSYS',
		'FLOWS_3000',
		'FLOWS_FILES',
		'GSMADMIN_INTERNAL',
		'GSMCATUSER',
		'GSMUSER',
		'HR',
		'IX',
		'LBACSYS',
		'MDDATA',
		'MDSYS',
		'MGMT_VIEW',
		'ODM',
		'ODM_MTR',
		'OE',
		'OJVMSYS',
		'OLAPSYS',
		'OPS$ORACLE',
		'ORACLE_OCM',
		'ORADATA',
		'ORADBA',
		'ORDPLUGINS',
		'ORDSYS',
		'OUTLN',
		'OWBSYS',
		'PERFSTAT',
		'PM',
		'PUBLIC',
		'REPADMIN',
		'SCOTT',
		'SH',
		'SI_INFORMTN_SCHEMA',
		'SPATIAL_CSW_ADMIN_USR',
		'SPATIAL_WFS_ADMIN_USR',
		'SQLTXADMIN',
		'SQLTXPLAIN',
		'SYS',
		'SYSBACKUP',
		'SYSDG',
		'SYSKM',
		'SYSMAN',
		'SYSTEM',
		'TRACESVR',
		'TSMSYS',
		'WK_TEST',
		'WKPROXY',
		'WKSYS',
		'WMSYS',
		'XDB',
		'XS$NULL',
		'GGS'
	)
and	object_name not like 'BIN$%'
group by
	owner,object_type
order by
	&&p_order_col;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80

set termout on
set serverout off
set feedback on
set echo off
