/*
 * Title  : sch_big_tab.sql
 * Author : EXADIME LLC
 * Created: 10-Oct-2023
 * Updated: 10-Oct-2023
 * Release: 1.0.0
 * Purpose: Shows top big tables in the database.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column rownum			format 9999		heading "#"
column owner			format a25		heading "Owner"
column segment_name		format a30		heading "Name"
column tablespace_name		format a30		heading "Tablespace"
column sum(bytes/1024/1024)	format 99,999,999	heading "MBytes|Size"

accept p_owner  char prompt "Enter Owner: "
accept p_rows   char prompt "Enter number of records to be displayed [10]: " default 10

spool &&rpt_dir/sch_big_tab.rpt

select
	rownum,
	t.*
from (
	select 
	    owner,
	    segment_name,
	    tablespace_name,
	    sum(bytes/1024/1024)
	from
	    dba_segments
	where
		segment_type in ('TABLE','TABLE PARTITION', 'TABLE SUB PARTITION')
	and	owner in (upper('&&p_owner'))
	group by
	    owner,
	    segment_name,
	    tablespace_name
	order by 4 desc  
) t
where
	rownum <= &&p_rows;

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
