/*
 * Title  : del_dup.sql
 * Author : EXADIME LLC
 * Created: 31-Jul-2017
 * Updated: 23-Mar-2018
 * Release: 1.0.0
 * Purpose: The following script deletes the duplicate records in the given table.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 100
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept table_name char prompt 'Enter Table Name : '
accept column_name char prompt 'Enter Column Name : '

spool &&rpt_dir/del_dup.rpt

delete from &&table_name
where rowid = any(select x.rowid 
		  from &&table_name x, &&table_name y
		  where x.&&column_name=y.&&column_name
		  and x.rowid>y.rowid);

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
