/*
 * Title  : db_info.sql
 * Author : EXADIME LLC
 * Created: 19-Aug-2021
 * Updated: 19-Aug-2021
 * Release: 1.0.0
 * Purpose: Shows database information.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno		format  99			heading "#"
column dbid		format	9999999999		heading "DB ID"
column name		format	a9			heading "DB Name"
column db_unique_name	format	a30			heading "DB Unique Name"
column open_mode	format	a20			heading "Open Mode"
column database_role	format	a16			heading "Database Role"
column log_mode		format	a12			heading "Log Mode"
column force_logging	format	a14			heading "Force Logging?"
column flashback_on	format	a10			heading "Flashback?"
column current_scn	format	99999999999999		heading "Current SCN"

spool &&rpt_dir/db_info.rpt

select 
	rownum as sno,
	dbid,
	name,
	db_unique_name,	
	open_mode,
	database_role,
	log_mode,
	force_logging,
	flashback_on,
	current_scn
from 
	v$database	
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 150
set long 80

set termout on
set serverout off
set feedback on
set echo off