/*
 * Title  : cr_rl.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: Generates non system roles (12c).
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

set serveroutput on
execute dbms_output.enable(10000000);

spool &&tmp_dir/cr_rl.tmp

prompt set feedback on echo on
prompt spool &&rpt_dir/cr_rl.rpt
prompt 
prompt --0.Non system role(s).

select 
        'CREATE ROLE '  || role || ';'
from
        dba_roles
where
	role not in (
		'ADM_PARALLEL_EXECUTE_TASK',
		'AQ_ADMINISTRATOR_ROLE',
		'AQ_USER_ROLE',
		'AUDIT_ADMIN',
		'AUDIT_VIEWER',
		'AUTHENTICATEDUSER',
		'CAPTURE_ADMIN',
		'CDB_DBA',
		'CONNECT',
		'CSW_USR_ROLE',
		'CTXAPP',
		'CWM_USER',
		'DATAPUMP_EXP_FULL_DATABASE',
		'DATAPUMP_IMP_FULL_DATABASE',
		'DBA',
		'DBFS_ROLE',
		'DELETE_CATALOG_ROLE',
		'EJBCLIENT',
		'EM_EXPRESS_ALL',
		'EM_EXRESS_BASIC',
		'EXECUTE_CATALOG_ROLE',
		'EXP_FULL_DATABASE',
		'GATHER_SYSTEM_STATISTICS',
		'GLOBAL_AQ_USER_ROLE',
		'HS_ADMIN_EXECUTE_ROLE',
		'HS_ADMIN_ROLE',
		'HS_ADMIN_SELECT_ROLE',
		'IMP_FULL_DATABASE',
		'JAVADEBUGPRIV',
		'JAVAIDPRIV',
		'JAVASYSPRIV',
		'JAVA_ADMIN',
		'JAVA_DEPLOY',
		'JMXSERVER',
		'LBAC_DBA',
		'LOGSTDBY_ADMINISTRATOR',
		'OEM_ADVISOR',
		'OEM_MONITOR',
		'OLAP_DBA',
		'OLAP_USER',
		'OLAP_XS_ADMIN',
		'OPTIMIZER_PROCESSING_RATE',
		'ORDADMIN',
		'PDB_DBA',
		'PROVISIONER',
		'RECOVERY_CATALOG_OWNER',
		'RESOURCE',
		'SCHEDULER_ADMIN',
		'SELECT_CATALOG_ROLE',
		'SPATIAL_CSW_ADMIN',
		'SPATIAL_WFS_ADMIN',
		'WFS_USR_ROLE',
		'WM_ADMIN_ROLE',
		'XDBADMIN',
		'XDB_SET_INVOKER',
		'XDB_WEBSERVICES',
		'XDB_WEBSERVICES_OVER_HTTP',
		'XDB_WEBSERVICES_WITH_PUBLIC',
		'XS_CACHE_ADMIN',
		'XS_NSATTR_ADMIN',
		'XS_RESOURCE',
		'XS_SESSION_ADMIN',
		'ENTPRISEMGR',
		'JAVAUSERPRIV',
		'MGMT_USER',
		'OLAPI_TRACE_USER',
		'XDBWEBSERVICES',
		'EM_EXPRESS_BASIC',
		'GDS_CATALOG_SELECT',
		'GSMADMIN_ROLE',
		'GSMUSER_ROLE',
		'GSM_POOLADMIN_ROLE',
		'RECOVERY_CATALOG_USER',
		'XS_NAMESPACE_ADMIN'
	)
order by
	1
/

prompt 
prompt --1.System privileges grante to role.

select 
	'GRANT ' || privilege || ' TO ' || role || ';'
from 
	role_sys_privs 
where 
	role not in (
		'ADM_PARALLEL_EXECUTE_TASK',
		'AQ_ADMINISTRATOR_ROLE',
		'AQ_USER_ROLE',
		'AUDIT_ADMIN',
		'AUDIT_VIEWER',
		'AUTHENTICATEDUSER',
		'CAPTURE_ADMIN',
		'CDB_DBA',
		'CONNECT',
		'CSW_USR_ROLE',
		'CTXAPP',
		'CWM_USER',
		'DATAPUMP_EXP_FULL_DATABASE',
		'DATAPUMP_IMP_FULL_DATABASE',
		'DBA',
		'DBFS_ROLE',
		'DELETE_CATALOG_ROLE',
		'EJBCLIENT',
		'EM_EXPRESS_ALL',
		'EM_EXRESS_BASIC',
		'EXECUTE_CATALOG_ROLE',
		'EXP_FULL_DATABASE',
		'GATHER_SYSTEM_STATISTICS',
		'GLOBAL_AQ_USER_ROLE',
		'HS_ADMIN_EXECUTE_ROLE',
		'HS_ADMIN_ROLE',
		'HS_ADMIN_SELECT_ROLE',
		'IMP_FULL_DATABASE',
		'JAVADEBUGPRIV',
		'JAVAIDPRIV',
		'JAVASYSPRIV',
		'JAVA_ADMIN',
		'JAVA_DEPLOY',
		'JMXSERVER',
		'LBAC_DBA',
		'LOGSTDBY_ADMINISTRATOR',
		'OEM_ADVISOR',
		'OEM_MONITOR',
		'OLAP_DBA',
		'OLAP_USER',
		'OLAP_XS_ADMIN',
		'OPTIMIZER_PROCESSING_RATE',
		'ORDADMIN',
		'PDB_DBA',
		'PROVISIONER',
		'RECOVERY_CATALOG_OWNER',
		'RESOURCE',
		'SCHEDULER_ADMIN',
		'SELECT_CATALOG_ROLE',
		'SPATIAL_CSW_ADMIN',
		'SPATIAL_WFS_ADMIN',
		'WFS_USR_ROLE',
		'WM_ADMIN_ROLE',
		'XDBADMIN',
		'XDB_SET_INVOKER',
		'XDB_WEBSERVICES',
		'XDB_WEBSERVICES_OVER_HTTP',
		'XDB_WEBSERVICES_WITH_PUBLIC',
		'XS_CACHE_ADMIN',
		'XS_NSATTR_ADMIN',
		'XS_RESOURCE',
		'XS_SESSION_ADMIN',
		'ENTPRISEMGR',
		'JAVAUSERPRIV',
		'MGMT_USER',
		'OLAPI_TRACE_USER',
		'XDBWEBSERVICES',
		'EM_EXPRESS_BASIC',
		'GDS_CATALOG_SELECT',
		'GSMADMIN_ROLE',
		'GSMUSER_ROLE',
		'GSM_POOLADMIN_ROLE',
		'RECOVERY_CATALOG_USER',
		'XS_NAMESPACE_ADMIN'
	)
order by
	1
/

prompt
prompt --2.Roles granted to role.

select 
	'GRANT ' || granted_role || ' TO ' || role || ';'
from 
	role_role_privs 
where 
	role not in (
		'ADM_PARALLEL_EXECUTE_TASK',
		'AQ_ADMINISTRATOR_ROLE',
		'AQ_USER_ROLE',
		'AUDIT_ADMIN',
		'AUDIT_VIEWER',
		'AUTHENTICATEDUSER',
		'CAPTURE_ADMIN',
		'CDB_DBA',
		'CONNECT',
		'CSW_USR_ROLE',
		'CTXAPP',
		'CWM_USER',
		'DATAPUMP_EXP_FULL_DATABASE',
		'DATAPUMP_IMP_FULL_DATABASE',
		'DBA',
		'DBFS_ROLE',
		'DELETE_CATALOG_ROLE',
		'EJBCLIENT',
		'EM_EXPRESS_ALL',
		'EM_EXRESS_BASIC',
		'EXECUTE_CATALOG_ROLE',
		'EXP_FULL_DATABASE',
		'GATHER_SYSTEM_STATISTICS',
		'GLOBAL_AQ_USER_ROLE',
		'HS_ADMIN_EXECUTE_ROLE',
		'HS_ADMIN_ROLE',
		'HS_ADMIN_SELECT_ROLE',
		'IMP_FULL_DATABASE',
		'JAVADEBUGPRIV',
		'JAVAIDPRIV',
		'JAVASYSPRIV',
		'JAVA_ADMIN',
		'JAVA_DEPLOY',
		'JMXSERVER',
		'LBAC_DBA',
		'LOGSTDBY_ADMINISTRATOR',
		'OEM_ADVISOR',
		'OEM_MONITOR',
		'OLAP_DBA',
		'OLAP_USER',
		'OLAP_XS_ADMIN',
		'OPTIMIZER_PROCESSING_RATE',
		'ORDADMIN',
		'PDB_DBA',
		'PROVISIONER',
		'RECOVERY_CATALOG_OWNER',
		'RESOURCE',
		'SCHEDULER_ADMIN',
		'SELECT_CATALOG_ROLE',
		'SPATIAL_CSW_ADMIN',
		'SPATIAL_WFS_ADMIN',
		'WFS_USR_ROLE',
		'WM_ADMIN_ROLE',
		'XDBADMIN',
		'XDB_SET_INVOKER',
		'XDB_WEBSERVICES',
		'XDB_WEBSERVICES_OVER_HTTP',
		'XDB_WEBSERVICES_WITH_PUBLIC',
		'XS_CACHE_ADMIN',
		'XS_NSATTR_ADMIN',
		'XS_RESOURCE',
		'XS_SESSION_ADMIN',
		'ENTPRISEMGR',
		'JAVAUSERPRIV',
		'MGMT_USER',
		'OLAPI_TRACE_USER',
		'XDBWEBSERVICES',
		'EM_EXPRESS_BASIC',
		'GDS_CATALOG_SELECT',
		'GSMADMIN_ROLE',
		'GSMUSER_ROLE',
		'GSM_POOLADMIN_ROLE',
		'RECOVERY_CATALOG_USER',
		'XS_NAMESPACE_ADMIN'
	)
order by
	1
/

prompt
prompt spool off

spool off

prompt Run the script "&&tmp_dir/cr_rl.tmp" manually.
prompt

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
