/*
 * Title  : awr_info.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 12-Nov-2021
 * Release: 1.0.0
 * Purpose: Shows AWR configuration details.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno	format 999			heading "#"
column di	format 99999999999		heading "Database Id"
column si	format 9,999,999,999,999	heading "Minutes|Snapshot Interval"
column rp	format 9,999,999,999,999	heading "Days|Retention Period"
column ts	format a10			heading "Top N SQL"
column sl	format a10			heading "Stat Level"

spool &&rpt_dir/awr_info.rpt

select
	rownum sno,
	dbid					di,
	extract(minute from snap_interval)	si,
	extract (day from retention)		rp,
	topnsql					ts,
	(
		select
			value
		from
			v$parameter
		where
			name='statistics_level'
	)					sl
from 
	dba_hist_wr_control
where
	dbid=(
		select
			dbid
		from
			v$database
	);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
