/*
 * Title  : acp_run.sql
 * Author : EXADIME LLC
 * Created: 3-JUL-2017
 * Updated: 3-JUL-2017
 * Release: 1.0
 * Purpose: Auto Capacity Planner
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on

set linesize 100
set pagesize 0

set heading on
set headsep on
set underline on
set colsep " "

set verify off
set escape off
set embedded on

spool &&rpt_dir/acp_run.rpt

--1.Make an entry in acp_db_run table for each database to be monitored.
--2.Create database link to that database with the same name as specified in acp_db_run.db_link column.

--For one database.
define p_db_run_key=<key>

exec asb.pkg_acp.pop_db_sgs(&&p_db_run_key);
exec asb.pkg_acp.pop_ts_sgs(&&p_db_run_key);
exec asb.pkg_acp.pop_us_sgs(&&p_db_run_key);

--For all databases.
exec asb.pkg_acp.pop_sgs;
exec asb.pkg_acp.gen_sgr;

spool off

set embedded off
set escape off
set verify on

set colsep " "
set underline on
set headsep on
set heading on

set pagesize 24
set linesize 80

set serverout off
set feedback on
set echo off