/*
 * Title  : tab_part_stat.sql
 * Author : EXADIME LLC
 * Created: 19-Jan-2021
 * Updated: 20-Jan-2021
 * Release: 1.0.0
 * Purpose: Shows table partition statistics.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno                    format 9999            heading "#"
column partition_name	      format a30             heading "Part Name"
column subpartition_name      format a30             heading "Sub Part Name"
column partition_position     format 9,999,999       heading "Part Pos"
column subpartition_position  format 999,999,999     heading "Sub Part Pos"
column high_value             format a32             heading "High Value"
column num_rows		      format 9,999,999,999   heading "Rows"
column sample_size	      format 9,999,999,999   heading "Sample"
column stattype_locked        format a7              heading "Locked?"
column stale_stats            format a6              heading "Stale?"
column last_analyzed          format a10             heading "Analyzed?"

accept p_owner prompt 'Enter schema name: '
accept p_table prompt 'Enter table name: '
accept p_order prompt "Enter order by column {1|2|3|4|5|6|7|8|9|10} [asc|desc] " default 3,5

spool &&rpt_dir/tab_part_stat.rpt

select 
	row_number() over(order by &&p_order) sno,
	partition_name,
	partition_position,
	subpartition_name,
	subpartition_position,
	high_value,
	num_rows,
	sample_size,
	stattype_locked,
	stale_stats,
	last_analyzed
from (
	select 
		s.partition_name,
		s.partition_position,
		s.subpartition_name,
		s.subpartition_position,
		p.high_value,
		s.num_rows,
		s.sample_size,
		s.stattype_locked,
		s.stale_stats,
		s.last_analyzed
	from
		dba_tab_partitions p,
		dba_tab_statistics s
	where
		p.table_owner=s.owner
	and	p.table_name=s.table_name
	and	p.partition_name=s.partition_name
	and	s.owner=upper('&&p_owner')
	and	s.table_name=upper('&&p_table')
     )
order by
	&&p_order
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
