/*
 * Title  : stat_job_ses.sql
 * Author : EXADIME LLC
 * Created: 06-Jul-2017
 * Updated: 06-Jul-2017
 * Release: 1.0.0
 * Purpose: Shows auto statistics gathering job sessions.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column rownum		format 9999		heading "#"
column spid		format a10		heading "SPID"
column sid		format 9999		heading "SID"
column serial#		format 99999999		heading "Serial#"
column username		format a30		heading "User Name"
column logon		format a20		heading "Logon Time"
column machine		format a20		heading "Machine"
column sql_id		format a15		heading "SQL Id"
column status		format a10		heading "Status"
column value		format 99,999,999,999	heading "Bytes|PGA"

accept p_top	prompt "Enter top rows [10]: " default 10;

spool &&rpt_dir/stat_job_ses.rpt

select
	rownum,
	spid,
	sid,
	serial#,
	username,
	to_char(logon_time,'dd-mon-yyyy hh:mi:ss')	logon,
	machine,
	sql_id,
	status,
	value
from (
	select
		p.spid,
		s.sid,
		s.serial#,
		s.username,
		s.logon_time,
		s.machine,
		s.sql_id,
		s.status,
		t.value
	from
		v$statname n,
		v$session s,
		v$sesstat t,
		v$process p
	where
		s.paddr=p.addr
	and	s.sid=t.sid
	and	n.statistic#=t.statistic#
	and	s.type='USER'
	and	s.username is not null
	and 	n.name='session pga memory'
	and	s.module='DBMS_SCHEDULER'
	order by
		t.value desc
)
where
	rownum<=&&p_top
order by
	value desc;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off