/*
 * Title  : sho_px_dtl.sql
 * Author : EXADIME LLC
 * Created: 27-Apr-2021
 * Updated: 27-Apr-2021
 * Release: 1.0.0
 * Purpose: Shows P1/P2/P3 file and object name.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "#"                 format 999
col "Owner"             format a30
col "File Name"         format a70
col "Object Name"       format a30

accept p1 char prompt "Enter P1 "
accept p2 char prompt "Enter P2 "

spool &&rpt_dir/sho_px_dtl.rpt

select
        rownum	       "#",
        file_name      "File Name"
from
	dba_data_files
where
	file_id=&&p1;

select
	rownum		"#",
	owner,
	segment_name	"Object Name"
from
	dba_extents
where
	file_id=&&p1
and	&&p2 between block_id
and	block_id+blocks;

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
