/*
 * Title  : sho_dep_tab.sql
 * Author : EXADIME LLC
 * Created: 01-Aug-2017
 * Updated: 12-Jul-2022
 * Release: 1.0.0
 * Purpose: This script shows child/dependent tables for the given table.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col sno         format 999	heading "#"
col owner	format a30	heading "Owner"
col tname 	format a30	heading "Table"

accept p_owner char prompt "Enter Owner "
accept p_table_name char prompt "Enter Table Name "
accept p_order_col char prompt "Enter Order by column {1|2} [asc|desc] " default 1,2

spool &&rpt_dir/sho_dep_tab.rpt

select
	rownum sno,
	owner,
	table_name tname
from (
	select 
		distinct
		owner,
		table_name
	from 
		dba_constraints 
	where
		r_constraint_name in (
			select 
				constraint_name 
			from 
				dba_constraints 
			where 
				constraint_type='P' 
			and 	owner=upper('&&p_owner')
			and	table_name=upper('&&p_table_name')
		)
	and	r_owner=upper('&&p_owner')
	order by
		&&p_order_col
)
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
