/*
 * Title  : sho_db_psu_19c.sql
 * Author : EXADIME LLC
 * Created: 02-Dec-2020
 * Updated: 02-Dec-2020
 * Release: 1.0.0
 * Purpose: To display database patchset update.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum		format 999		heading "#"
col target_version	format a11		heading "Version"
col patch_id		format 999999999	heading "Patch Id"
col patch_type		format a8        	heading "Type"
col description  	format a80		heading "Description"
col action		format a8		heading "Action"
col action_time		format a30		heading "Time"
col status		format a12		heading "Status"

accept p_rows  char prompt "Enter number of records to be displayed [10]: " default 10

spool &&rpt_dir/sho_db_psu_19c.rpt

select 
	rownum,
	target_version,
	patch_id,
	patch_type,
	description,
	action,
	action_time,
	status
from ( 
	select 
		target_version,
		patch_id,
		patch_type,
		description,
		action,
		action_time,
		status
	from 
		dba_registry_sqlpatch
	order by
		action_time desc
) where
	rownum<=&&p_rows;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off