/*
 * Title  : sho_db_psu_11g.sql
 * Author : EXADIME LLC
 * Created: 14-Sep-2020
 * Updated: 14-Sep-2020
 * Release: 1.0.0
 * Purpose: To display database patchset update in 11g.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum		format 999		heading "#"
col version		format a10		heading "Version"
col id			format 999999999	heading "Patch Id"
col bundle_series	format a6		heading "Bundle"
col comments		format a25		heading "Comments"
col action		format a8		heading "Action"
col action_time		format a30		heading "Time"

accept p_rows  char prompt "Enter number of records to be displayed [10]: " default 10

spool &&rpt_dir/sho_db_psu_11g.rpt

select 
	rownum,
	version,
	id,
	bundle_series,
	comments, 
	action, 
	action_time
from   
	sys.registry$history
where  
	comments like '%PSU%'
and    
	action = 'APPLY'
and
	rownum<=&&p_rows
order by
	action_time desc;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off