/*
 * Title  : sho_db_prop.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: To display database properties.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col sno		format 999	heading "#"
col name	format a35	heading "Property Name"
col value	format a35	heading "Property Value"

spool &&rpt_dir/sho_db_prop.rpt

select
      rownum			"sno",
      property_name     	"name",
      property_value         	"value"
from
      database_properties;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off