/*
 * Title  : sho_db_lock.sql
 * Author : EXADIME LLC
 * Created: 31-Jul-2017
 * Updated: 31-Jul-2017
 * Release: 1.0
 * Purpose: This script shows locks in the database.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column "#"		format 9999
column "Owner"		format a30
column "Object Name"	format a30
column "Object Type"	format a20
column "Lock Type"	format a9
column "Lock Mode"	format a20
column "SID"		format 9999

accept p_order char prompt "Enter order by column {1|2|3|4|5|6|7} [asc|desc] " default 2,3,4,5,6,7

spool &&rpt_dir/sho_db_lock.rpt

select 
	row_number() over(order by &&p_order)	"#",
	o.owner					"Owner",
	o.object_name				"Object Name", 
	o.object_type				"Object Type", 
	l.type					"Lock Type",
	decode(
		l.lmode,
		0, 'None',
		1, 'Null',
		2, 'Row Share',
		3, 'Row Exclusive',
		4, 'Share',
		5, 'Shared Row Exclusive',
		6, 'Exclusive', 
		'Null'
	)				"Lock Mode",
	l.sid				"SID"
from
	dba_objects o,
	v$lock l
where 
	l.id1=+o.object_id
and	o.owner not in (
		'SYS',
		'SYSTEM',
		'AUDSYS',
		'GSMADMIN_INTERNAL'
		,'GSMCATUSER'
		,'GSMUSER'
		,'OJVMSYS'
		,'SYSBACKUP'
		,'SYSKM'
		,'XS$NULL'
		,'SYSDG',
		'DBSNMP',
		'OUTLN',
		'MDSYS',
		'ORDSYS',
		'ORDPLUGINS',
		'CTXSYS',
		'DSSYS',
		'WKPROXY',
		'WKSYS',
		'WMSYS',
		'XDB',
		'ANONYMOUS',
		'ODM',
		'ODM_MTR',
		'OLAPSYS',
		'TRACESVR',
		'PERFSTAT',
		'REPADMIN',
		'EXFSYS',
		'DMSYS',
		'SYSMAN',
		'DIP',
		'TSMSYS',
		'DVF',
		'DVSYS',
		'WKUSER',
		'WK_TEST',
		'LBACSYS',
		'SI_INFORMTN_SCHEMA',
		'APPQOSSYS',
		'ORACLE_OCM',
		'RMAN',
		'GGS',
		'ORACLE',
		'SYS$UMF',
		'GGSYS',
		'DBSFWUSER',
		'ORADBA',
		'REMOTE_SCHEDULER_AGENT',
		'SYSRAC',
		'PUBLIC'
	)
order by
	&&p_order
/

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
