/*
 * Title  : fra_info.sql
 * Author : EXADIME LLC
 * Created: 18-Oct-2023
 * Updated: 18-Oct-2023
 * Release: 1.0.0
 * Purpose: Shows flash recovery area usage details.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno				format 9999		heading "#"
column con_id				format 9999		heading "Con Id"
column file_type			format a30		heading "File Type"                      
column number_of_files			format 9999999		heading "Files"                  
column percent_space_used		format 999.99		heading "%|Used"              

accept p_order char prompt "Enter order by column {1|2|3|4|5|6} [asc|desc] " default 3

spool &&rpt_dir/fra_info.rpt

select
	row_number() over(order by &&p_order)               sno,
	con_id,
	file_type,
	number_of_files,
	percent_space_used
from(
	select
		file_type,
		percent_space_used,
		number_of_files,
		con_id
	from 
		v$flash_recovery_area_usage
) order by
        &&p_order
/

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
