/*
 * Title  : app_user_free.sql
 * Author : EXADIME LLC
 * Created: 1-Aug-2017
 * Updated: 1-Aug-2017
 * Release: 1.0
 * Purpose: The following script shows the space used by app users in the database.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col sno	    format 9999		heading "#"
col used    format 99,999,999	heading "MB|Used"
col owner   format a30          heading "Name"

compute sum of used on report
break on report

accept p_order char prompt "Enter order by column {1|2|3} [asc|desc] " default 3

spool &&rpt_dir/app_user_free.rpt

select
	row_number() over(order by &&p_order) sno,
	owner,
	sum(bytes)/1024/1024 used
from (
	select 
		owner,
		bytes
	from 
		dba_extents
	where
		owner not in (
			'SYS',
			'SYSTEM',
			'AUDSYS',
			'GSMADMIN_INTERNAL'
			,'GSMCATUSER'
			,'GSMUSER'
			,'OJVMSYS'
			,'SYSBACKUP'
			,'SYSKM'
			,'XS$NULL'
			,'SYSDG',
			'DBSNMP',
			'OUTLN',
			'MDSYS',
			'ORDSYS',
			'ORDPLUGINS',
			'CTXSYS',
			'DSSYS',
			'WKPROXY',
			'WKSYS',
			'WMSYS',
			'XDB',
			'ANONYMOUS',
			'ODM',
			'ODM_MTR',
			'OLAPSYS',
			'TRACESVR',
			'PERFSTAT',
			'REPADMIN',
			'EXFSYS',
			'DMSYS',
			'SYSMAN',
			'DIP',
			'TSMSYS',
			'DVF',
			'DVSYS',
			'WKUSER',
			'WK_TEST',
			'LBACSYS',
			'SI_INFORMTN_SCHEMA',
			'APPQOSSYS',
			'ORACLE_OCM',
			'RMAN',
			'GGS',
			'ORACLE',
			'SYS$UMF',
			'GGSYS',
			'DBSFWUSER',
			'ORADBA',
			'REMOTE_SCHEDULER_AGENT',
			'SYSRAC',
			'ORDDATA',
			'MDDATA',
			'SPATIAL_CSW_ADMIN_USR'
		)
	) 
group by 
		owner
order by
	&&p_order
/

spool off;

clear columns
clear computes

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
